### Test module ####
import random
import math

from demoscript import *

#getModuleOrder()

class RandomImage(Image):
	def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1,orders=[],scaling=1):
		Image.__init__(self,img,0,0)
		self.xpos=xpos
		self.ypos=ypos
		self.xamp=xamp
		self.yamp=yamp
		self.orders=orders
		self.scaling=scaling
	
	def setAmpY(self,amp):
		self.yamp=amp

	def setAmpX(self,amp):
		self.xamp=amp

	def callback(self):
		pass

	def revive(self):

		if self.orders==[] or getModuleOrder() in self.orders:
			self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
			self.opacity.setTargetValue(2)
			if self.scaling:
				self.scaleY.setTargetValue(0)

class RandomImage2(Image):
	def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1):
		Image.__init__(self,img,0,0)
		self.xpos=xpos
		self.ypos=ypos
		self.xamp=xamp
		self.yamp=yamp
	
	def setAmpY(self,amp):
		self.yamp=amp

	def setAmpX(self,amp):
		self.xamp=amp

	def callback(self):
		pass

	def revive(self):
		xpos=self.xpos+frand(-self.xamp,self.xamp)
		ypos=self.ypos+frand(-self.yamp,self.yamp)
		xpos=xpos*10
		xpos=math.floor(xpos)
		xpos/=10
		
		self.setPos(xpos,ypos)
		self.opacity.setTargetValue(2)
		self.scaleY.setTargetValue(0)



class ScrollImage(Image):
	def __init__(self,img,xpos=-2.4,ypos=0,xamp=1,yamp=1):
		Image.__init__(self,img,0,0)
		self.xpos=xpos
		self.ypos=ypos
		self.xamp=xamp
		self.yamp=yamp
		self.opacity=FixedSlider(1,1)
		self.posX=FixedSlider(5,5)
		self.posX.setMode(1)
		self.posX.setDamping(0.0085)
		self.posX.setFixPointDamping(0.99)

		
	def setAmpY(self,amp):
		self.yamp=amp

	def setAmpX(self,amp):
		self.xamp=amp

	def callback(self):
		pass

	def revive(self):
#		self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
		self.posX.setTargetValue(-10)

		
		self.opacity.setTargetValue(2)
#		self.scaleY.setTargetValue(0)



class MeneerImage(Image):
	def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1):
		Image.__init__(self,img,0,0)
		self.xpos=xpos
		self.ypos=ypos
		self.xamp=xamp
		self.yamp=yamp
	
	def setAmpY(self,amp):
		self.yamp=amp

	def setAmpX(self,amp):
		self.xamp=amp


	def callback(self):
		self.setPos(frand(-0.5,0.5),0)

	def revive(self):
		self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
		self.opacity.setTargetValue(1)


class SimpleRipple(Ripple):
	def __init__(self):
		Ripple.__init__(self)
#		self.amplitude=FixedSlider(0,0)
		self.callbacks=[]

	def callback(self):
		for f in self.callbacks:
			f(self)





class SimpleImageSeq(ImageSeq):
	def __init__ (self,images=[],nextImage=[],take=0):
		ImageSeq.__init__(self)
		self.nextImageEvents=nextImage
		self.images=images
		for i in self.images:self.addImage(i)
		self.takeAmount=take

	
	def callback (self):
		for event in self.nextImageEvents:
			if getEvent(EC_NOTE_ON,event):
				if self.takeAmount > 0:
					self.take(self.takeAmount)
				else:
					self.next()


class AutoImageSeq(ImageSeq):
	def __init__ (self,images=[],time=10,take=0):
		ImageSeq.__init__(self)
#		self.nextImageEvents=nextImage
		self.images=images
		for i in self.images:self.addImage(i)
		self.takeAmount=take
		self.time=time
		self.curtime=0

	
	def callback (self):
#		for event in self.nextImageEvents:
		self.curtime+=1
		if self.curtime==self.time:
			if self.takeAmount > 0:
				self.take(self.takeAmount)
			else:
				self.next()
			self.curtime=0

class HackImageSeq(ImageSeq):
	# event format is event,amount,minrange,maxrange
	def __init__ (self,images=[],time=10,autosize=0,events=[]):
		ImageSeq.__init__(self)
#		self.nextImageEvents=nextImage
		self.images=images
		for i in self.images:self.addImage(i)
		self.time=time
		self.curtime=0
		self.curImage=0
		self.autosize=autosize
		self.events=events
		self.callBacks=[]

	
	def callback (self):
		self.curtime+=1
		if self.curtime==self.time:
	 	  	self.take(1,0,self.autosize)
			self.curtime=0

		for event in self.events:
			if getEvent(EC_NOTE_ON,event[0]):
				self.take(event[1],event[2],event[3])

		for callBack in self.callBacks:
			if getEvent(EC_NOTE_ON,callBack[0]):
				callBack[1](callBack[0])
				
				
			
class SimpleXMV(XMVPlayer):
	def __init__(self,name,events=[]):
		XMVPlayer.__init__(self,name)
		self.events=events
		
	def callback(self):
		for event in events:
			if getEvent(EC_NOTE_ON,event): self.restart()


class FixedGamma(RGBMap):
	def __init__(self,events=[],colors=[5,5,5]):
		RGBMap.__init__(self)
		self.gamma=MGGamma();
		self.gamma.connectOutput(self,"map")
		self.gamma.red=FixedSlider(colors[0],colors[0])
		self.gamma.green=FixedSlider(colors[1],colors[1])
		self.gamma.blue=FixedSlider(colors[2],colors[2])



	def callback(self):
		pass
		

#		self.events=events
#		self.gamma=MGGamma();
#		self.gamma.connectOutput(self,"map")

class SimpleGamma(RGBMap):
	def __init__(self,events=[],colors=[5,5,5]):
		RGBMap.__init__(self)
		self.events=events
		self.gamma=MGGamma();
		self.gamma.connectOutput(self,"map")
		self.colors=colors
		self.gamma.red.setFixPointDamping(0.97)
		self.gamma.green.setFixPointDamping(0.97)
		self.gamma.blue.setFixPointDamping(0.97)

	
	def callback(self):
		for event in self.events:
			if getEvent(EC_NOTE_ON,event):
				sg=self.gamma
				for i in zip([sg.red,sg.green,sg.blue],self.colors):i[0].setTargetValue(i[1])

class SimpleOverflow(RGBMap):
	def __init__(self,events=[],colors=[0.9,0.9,0.4]):
		RGBMap.__init__(self)
		self.events=events
		self.gamma=MGOverflow();
		self.gamma.connectOutput(self,"map")
		self.colors=colors
		self.gamma.red.setFixPointDamping(0.97)
		self.gamma.green.setFixPointDamping(0.97)
		self.gamma.blue.setFixPointDamping(0.97)

	
	def callback(self):
		for event in self.events:
			if getEvent(EC_NOTE_ON,event):
				sg=self.gamma
				for i in zip([sg.red,sg.green,sg.blue],self.colors):i[0].setTargetValue(i[1])

	

class RandomOverflow(RGBMap):
	def __init__(self,events=[],colors=[0.9,0.9,0.4]):
		RGBMap.__init__(self)
		self.events=events
		self.gamma=MGOverflow();
		self.gamma.connectOutput(self,"map")
		self.colors=colors
		self.gamma.red.setFixPointDamping(1)
		self.gamma.green.setFixPointDamping(1)
		self.gamma.blue.setFixPointDamping(1)

	
	def callback(self):
		for event in self.events:
			if getEvent(EC_NOTE_ON,event):
				sg=self.gamma
				for i in zip([sg.red,sg.green,sg.blue],self.colors):i[0].setTargetValue(frand(-20,20))



class SimpleBlur(Blur):
	def __init__(self,events=[],restv=0.0,highv=1.0):
		Blur.__init__(self)
		self.m_events=events
		self.mix=FixedSlider(restv,restv)
		self.highv=highv
	
	def callback(self):
		for event in self.m_events:
			if getEvent(EC_NOTE_ON,event):
				self.mix.setTargetValue(self.highv)
				self.mix.setFixPointDamping(0.9995)
				self.mix.setDamping(0.97)

class SimpleDistort(Distort):
	def __init__(self,event=[],distVal=0):
		Distort.__init__(self)
		self.m_event=event
		self.amount=FixedSlider(distVal,distVal)
		

	def callback(self):
		for event in self.m_event:
			if getEvent(EC_NOTE_ON,event[1]):
				self.amount.setTargetValue(event[0])
				self.amount.setFixPointDamping(0.99)
				self.amount.setDamping(0.97)
				


	


class SimpleNoise(Noise):
	""" SimpleNoise renders noise 
	"""
	

	def __init__(self,event,intensity=0.6,eventIntensity=1.3):
		Noise.__init__(self)
		self.m_event=event
		self.intensity=FixedSlider(intensity,intensity)
		self.eventIntensity=eventIntensity
		self.intensity.setFixPointDamping(0.96)
	def callback(self):
		for event in self.m_event:
			if getEvent(EC_NOTE_ON,event):
				self.spread.setTargetValue(0)
				self.intensity.setTargetValue(self.eventIntensity)
			
#HELEMAAL NIET ZO SIMPEL!
class SimpleScene(Scene):
	""" 
	Simple scene renders the given scene and responds to events defined in nextCamera and reset.
	"""

	def __init__(self,sceneName,nextCamera=[],reset=[],cameraOrder=[],offsets=[],curveEvents=[],noiseEvents=[],speeds=[],defaultspeed=8000,transforms=[],colors=[],curveWidth=5,p=1.0):
		self.p=p
		Scene.__init__(self)
		self.sceneProxy=SceneProxy(sceneName)
		self.setScene(self.sceneProxy)
		if cameraOrder==[]:cameraOrder=range(self.getNumCameras())
		self.cameraOrder=cameraOrder
		self.nextCameraEvents=nextCamera
		self.resetEvents=reset
		self.speed=FixedSlider(defaultspeed,defaultspeed)
		self.curveWidth=curveWidth
		self.missedLast=0
		self.missCallBacks=[]
		self.callBacks=[]


		self.curCam=0
#		self.setCamera(cameraOrder[0])
		self.offsetEvents=offsets
		self.speedEvents=speeds

		self.curveEvents=curveEvents
		self.noiseEvents=noiseEvents

		self.transformEvents=transforms
		self.colorEvents=colors
#		self.setCamera(1)

		meshes=self.getScene().getObjects()
		for transform in self.transformEvents:
			meshes[transform[0]].addTransform(transform[1])

	def callback(self):
		r = frand(0,1)
		if self.missedLast == 1:
			r = 0
			self.missedLast = 0

		if r>self.p:
			self.missedLast+=1
		

		missedEvents=[]
		
		for nc in self.nextCameraEvents:
			if getEvent(EC_NOTE_ON,nc):
				if r <= self.p:

					if self.cameraOrder==[]:
						self.nextCamera()
					else:
						self.curCam=self.curCam+1
						if self.curCam==len(self.cameraOrder):
							self.curCam=0
				else:
					missedEvents.append(nc)
	
		if self.cameraOrder!=[]:
		  self.setCamera(self.cameraOrder[self.curCam])

		for rc in self.resetEvents:
			if getEvent(EC_NOTE_ON,rc):
				if r <= self.p:
					self.reset()
				else:
					missedEvents.append(rc)

		for offset in self.offsetEvents:
			if getEvent(EC_NOTE_ON,offset[1]):
				self.offset.setTargetValue(offset[0])
			
		for speed in self.speedEvents:
			if getEvent(EC_NOTE_ON,speed[0]):
				self.speed.setTargetValue(speed[1])
				
		
		for transform in self.transformEvents:
			if getEvent(EC_NOTE_ON,transform[2]):

				if self.curCam != 1:
					scale=frand(-6,6)
					transform[1].angle.setTargetValue(scale)
				


			
#process curves
		if len(self.curveEvents)>0:	#hack
			meshes=self.getScene().getObjects()
			for event in self.curveEvents:
				if getEvent(EC_NOTE_ON,event[1]):
					if event[0]<len(meshes):
						meshes[event[0]].curveWidth.setMode(1)
						meshes[event[0]].curveWidth.setTargetValue(frand(2,4))
						meshes[event[0]].curveLength.setMode(2)
						meshes[event[0]].curveLength.setFixPointDamping(0.99)
						meshes[event[0]].curveLength.setDamping(0.4)
						meshes[event[0]].curveLength.setTargetValue(frand(0,1))
						meshes[event[0]].curveBumpFreq.setMode(1)
						meshes[event[0]].curveBumpAmplitude.setMode(1)
						meshes[event[0]].curveBumpFreq.setTargetValue(5)
						meshes[event[0]].curveBumpAmplitude.setTargetValue(0.6)
					
			
#process perlin noise
		if len(self.noiseEvents)>0:	#hack
			meshes=self.getScene().getObjects()
			for event in self.noiseEvents:
				if getEvent(EC_NOTE_ON,event[1]):
					if event[0]<len(meshes):

						meshes[event[0]].noiseAmplitude.setFixPointDamping(0.9995)
						meshes[event[0]].noiseAmplitude.setTargetValue(25)
						meshes[event[0]].noiseFreq.setTargetValue(0.02)
						meshes[event[0]].noiseFreq.setFixPoint(0.025)
						meshes[event[0]].noiseOffset.setMode(1)
						meshes[event[0]].noiseOffset.setDamping(0.01)
						meshes[event[0]].noiseOffset.setTargetValue(1000)
		

		

#process color modulation
		if len(self.colorEvents)>0:	#hack

			meshes=self.getScene().getObjects()
			for event in self.colorEvents:
				if getEvent(EC_NOTE_ON,event[1]):
					p = 0.5
					if len(event) == 7:
						p = event[6]
					
					if event[0]<len(meshes) and frand(0,1) < p:
						c=frand(0,5)
						if len(event) == 2:
							meshes[event[0]].red.setTargetValue(c*5)
							meshes[event[0]].green.setTargetValue(0)
							meshes[event[0]].blue.setTargetValue(0)
						if len(event) == 5:
							meshes[event[0]].red.setTargetValue(event[2])
							meshes[event[0]].green.setTargetValue(event[3])
							meshes[event[0]].blue.setTargetValue(event[4])
						if len(event) >= 6:
							var=1+frand(0,event[5])-event[5]/2
							meshes[event[0]].red.setTargetValue(event[2]*var)
							meshes[event[0]].green.setTargetValue(event[3]*var)
							meshes[event[0]].blue.setTargetValue(event[4]*var)							


# hmhmhmhm daarnet werkte het nog
# als dit werkt eet ik mijn schoen op
		event=Event()
		if getEvent(EC_NOTE_CONTROL,0,6,event):
			#misschien moet dit meer zijn! 
			for mesh in meshes:
				mesh.red.setTargetValue(1.0-event.volume)
				mesh.green.setTargetValue(1.0-event.volume)
				mesh.blue.setTargetValue(1.0-event.volume)

		if r > self.p:		
			for callBack in self.missCallBacks:
				if callBack[0] in missedEvents:
					callBack[1](self)
		
		for callBack in self.callBacks:
			if getEvent(EC_NOTE_ON,callBack[0]):
				callBack[1](self,callBack[0])
